<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="ISO-8859-1">
    <title>Sistema de Sorteio Online - Instituto Federal do Norte de Minas Gerais (IFNMG)</title>
</head>
<body>
    <header style="text-align: center;">
        <!-- Ajuste o tamanho da imagem aqui -->
        <img src="logo.png" alt="Logo" width="400" height="auto" style="display: block; margin: 0 auto;">
        <h1>Sistema de Sorteio Online</h1>
        <p> ** Envie seu arquivo com extensão CSV.<br />
        ** O sistema trocará as linhas do arquivo aleatoriamente.</p>
    </header>

    <form method="POST" enctype="multipart/form-data" style="text-align: center;">
        <table border="0" style="margin: 0 auto;">
            <tr>
                <td>Arquivo CSV com os Inscritos:</td>
                <td colspan="3"><input type="file" name="arquivoCSV" accept=".csv"></td>
            </tr>
            <tr>
                <td width="270">
                    <input type="checkbox" name="cvalidaManual" id="cvalidaManual" onclick="document.getElementById('cvalida').disabled = !this.checked;">
                    Habilitar validação manual
                </td>
                <td>Código de validação: <input type="text" name="cvalida" id="cvalida" size="20" maxlength="50" disabled></td>
            </tr>
			<tr>
                <td colspan="2"><input type="submit" name="gerarLista" value="Gerar Lista Sorteada"></td>
            </tr>
        </table>
    </form>
	
    <?php
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        if (isset($_POST['gerarLista'])) {
            $cvalidaManual = isset($_POST['cvalidaManual']);
            $cvalida = $cvalidaManual ? (int)$_POST['cvalida'] : time();

            if (isset($_FILES['arquivoCSV']) && $_FILES['arquivoCSV']['error'] === UPLOAD_ERR_OK) {
                $arquivoTmp = $_FILES['arquivoCSV']['tmp_name'];
                $csv = array_map('str_getcsv', file($arquivoTmp));
                $listaInscritos = array_column($csv, 0);
                $listaInscritos = array_map('trim', $listaInscritos);
                $totalInscritos = count($listaInscritos);

                if ($totalInscritos === 0) {
                    echo "<p style='color: red;'>O arquivo CSV está vazio. Por favor, insira uma lista válida de inscritos.</p>";
                    exit;
                }
            } else {
                echo "<p style='color: red;'>Erro no upload do arquivo. Por favor, envie um arquivo CSV.</p>";
                exit;
            }

            function gereListaEmbaralhada($lista, $cvalida) {
                srand($cvalida);
                shuffle($lista);
                return $lista;
            }

            $embaralhada = gereListaEmbaralhada($listaInscritos, $cvalida);

            echo "<div style='text-align: center; margin-top: 20px;'>";
            echo "<h2>Lista <b>oficial</b> do sorteio público</h2>";
            echo "Horário do sorteio: " . date('d/m/Y, H:i:s', $cvalida) . "<br>";
            echo "<h3>Resultado</h3>";

            echo "<form method='POST' action='download.php' style='margin-top: 20px;'>
                    <input type='hidden' name='listaCSV' value='" . htmlspecialchars(implode("\n", $embaralhada), ENT_QUOTES, 'ISO-8859-1') . "'>
                    <input type='hidden' name='baixarCSV' value='1'>
                    <input type='hidden' name='cvalida' value=$cvalida>
                    <input type='submit' value='Baixar lista sorteada em CSV'>
                  </form>";
            echo "<br>";
            echo "<table border='1' style='margin: 0 auto;'>
                    <tr>
                        <th>SEQUENCIA ORIGINAL</th>
                        <th>SEQUENCIA SORTEADA</th>
                    </tr>
                    <tr>
                        <td>";

            for ($i = 0; $i < $totalInscritos; $i++) {
                echo "<font size='4'><tt>" . htmlspecialchars($listaInscritos[$i], ENT_QUOTES, 'ISO-8859-1') . "</tt></font><br>";
            }

            echo "</td>
                    <td>";

            for ($i = 0; $i < $totalInscritos; $i++) {
                echo "<font size='4'><tt>" . htmlspecialchars($embaralhada[$i], ENT_QUOTES, 'ISO-8859-1') . "</tt></font><br>";
            }

            echo "</td>
                </tr>
            </table>";

            echo "<h3>Informações técnicas do sistema</h3>";
            echo "<b>Código de validação utilizado:</b> \"" . htmlspecialchars($cvalida, ENT_QUOTES, 'ISO-8859-1') . "\"<br>";
            echo "<b>Versão deste sistema:</b> 03/09/2024<br/>";
            echo "</div>";
			
        }
    }
    ?>
	<div style="text-align: center; margin-top: 20px;">
	   <br />
       <a href="codigo.zip">Baixar o c&oacute;digo fonte desse sistema de sorteios</a>
	</div>
</body>
</html>
